/*
-------------------------------------------------------------------------------------------
Macros for character assembly scripted plugin
By:Ravi Karra [Discreet] - ravi.karra@autodesk.com

Created:11/26/01

Revision History:

	07/24/03 - aszabo
		Removed code from createCharacters that was added to compensate for a problem in the group creation code
	
 	11 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macroscript file can be shared with all Discreet products
		moved the Macro_InitialPose.mcr inside this tool

 
--***********************************************************************************************
*/
macroScript CreateCharacter
category:~CREATECHARACTER_CAPTION~
internalCategory:"Characters"
tooltip:~CREATE_A_CHARACTER_TOOLTIP~
ButtonText:~CREATE_CHARACTER_BUTTONTTEXT~
(
	fn createCharacter nodes =
	(
		animate off
		(
			local chr = assemblyMgr.assemble nodes name:(uniqueName ~CHR_CHARACTER_NODES_NAME~) classDesc:CharacterAssembly
			if (chr != undefined) then
			(
				chr.assemblyBBoxDisplay = false
				chr.wirecolor = (colorMan.getColor #chr_color)*255			
			)
		)
		chr
	)
	
	rollout rSkippedCharacterNodes ~RSKIPPEDCHARACTERNODES_CAPTION~
	(
		label lbl ~LBL_CHARACTER_ASSEMBLY_CANNOT_BE_CREATED_CAPTION~  offset:~LBL_CHARACTER_ASSEMBLY_CANNOT_BE_CREATED_POSITION~ height:~LBL_CHARACTER_ASSEMBLY_CANNOT_BE_CREATED_HEIGHT~
		listBox lbSkipped ~LBSKIPPED_ERROR_NODES_CAPTION~ align:#center items:#() height:10
		button btnOK ~BTNOK_CAPTION~ width:40 height:20
		
		on rSkippedCharacterNodes open do
		(
			rSkippedCharacterNodes.lbSkipped.items = g_skipped_nodes
		)
		on lbSkipped selected idx do
		(
			select ( getNodeByName g_skipped_nodes[idx])
		)	
		on btnOK pressed do 
		(
			destroyDialog rSkippedCharacterNodes
		)
	)
	
	on execute do
	(		
		local obj_array = selection as array
		if assemblyMgr.canAssemble selection then	
		(
			undo ~UNDO_DESTROY_CHARACTER~ on 
			(
				local chr = createCharacter obj_array
				if chr != undefined then
				(
					assemblyMgr.open chr
					select chr
				)
			)
		)
		else
		(
			undo off
			(
				g_skipped_nodes = #()
				
				for obj in obj_array do
				(
					if obj.parent != undefined and (findItem obj_array obj.parent) == 0 then
					(
						append g_skipped_nodes obj.name
					)
				)
				createDialog rSkippedCharacterNodes width:300 height:250 modal:true
				select obj_array
			)
		)
	)
	on isEnabled do (selection.count > 0)
)


macroScript DestroyCharacter
category:~CREATECHARACTER_CATEGORY~
internalCategory:"Characters"
tooltip:~TOOLTIP_DESTROY_CHARACTER~
ButtonText:~BUTTONTTEXT_DESTROY_CHARACTER~
(
	on execute do
	(
		undo ~UNDO_DESTROY_CHARACTER_CAPTION~ on 
		(
			if (assemblyMgr.canClose selection) then
				max delete
			else
				assemblyMgr.disassemble selection
		)
	)
	on isEnabled do 
	(
		selection.count == 1 and ((assemblyMgr.canDisassemble selection) or 
		((isGroupHead $) and (assemblyMgr.canClose selection)))
	)
)

macroScript LockCharacter
category:~CHARACTERS_CATEGORY~
internalCategory:"Characters"
tooltip:~LOCK_A_CHARACTER_TOOLTIP~
ButtonText:~BUTTONTEXT_LOCK~
(
	on execute do
	(
		undo ~UNDO_LOCK_A_CHARACTER~ on
		(
			assemblyMgr.close selection select:false
		)
	)
	on isEnabled do (selection.count > 0 and (assemblyMgr.canClose selection))
)

macroScript UnLockCharacter
category:~UNLOCKCHARACTER_CHARACTERS_CATEGORY~
internalCategory:"Characters"
tooltip:~UNLOCKCHARACTER_TOOLTIP~
ButtonText:~UNLOCK_BUTTONTEXT~
(
	on execute do
	(
		undo ~UNDO_UNLOCK_CHARACTER~ on
		(		
			assemblyMgr.open selection
		)
	)
	on isEnabled do (selection.count > 0 and (assemblyMgr.canOpen selection))
)

macroScript InsertCharacter
category:~INSERTCHARACTER_CATEGORY~
internalCategory:"Characters"
tooltip:~INSERT_A_CHARACTER_TOOLTIP~
ButtonText:~INSERT_CHARACTER_BUTTONTEXT~
(
	on execute do
	(
		local seed = pathConfig.getDir #animations + "\\"
		local f = getOpenFileName filename:seed types:~CHR_FILE_FILTER~
		if f != undefined then
		(
			undo off
			(
				mergeMaxFile f #mergeDups #select #promptDups
			)
		)		
	)
--	on isEnabled do (selection.count > 0)
)

macroScript SaveCharacter
category:~SAVECHARACTER_CHARACTERS_CATEGORY~
internalCategory:"Characters"
tooltip:~SAVE_A_CHARACTER_TOOLTIP~
ButtonText:~SAVE_CHARACTER_BUTTONTEXT~
(
	fn getGroupHead objs = 
	(
		local result = undefined
		local keepgoing = true
		for ob in objs where keepgoing == true do 
		(
			if ob.assemblyHead do 
			(
				result = ob
				keepgoing = false
			)
		)
		result
	)
	on execute do
	(
		undo off
		(
			local objs = selection as array
			local f = getSaveFileName types:~CHR_FILE_TYPE_FILTER~
			if f != undefined then
			(
				redrawOff
				(
					g_suspendCharacterRedraw = true
					local head = (getGroupHead objs)
					local parentNode = head.parent
					head.parent = undefined
					local locked = assemblyMgr.canOpen head
					if not locked then 
					(
						assemblyMgr.close head --select:true
					)
					select head		
					saveNodes selection f
					format ~FORMATTED_CHARACTER_LOCKED_CAPTION~ locked
					if not locked then 
					(
						assemblyMgr.open head clearSelection:false
					)
					head.parent = parentNode
					g_suspendCharacterRedraw = false
					select objs
				)
			)
		)
	)
	on isEnabled do 
	(
		(selection.count == 1 and (classof selection[1]) == CharacterAssembly) or
		(selection.count > 1 and (classof (getGroupHead selection)) == CharacterAssembly)
	)
)

--------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------
/*
SkinPose Macros

--
-- Created: January 4, 2002
-- Last Updated: January 4, 2002
--
-- Author : Jianmin Zhao
-- Version:  3ds max 5
--
-- Loop over selected objects and apply setSkinPose(), assumeSkinPose(),
-- and toggle skinPoseMode.
--

*/
macroScript SetSkinPose
ButtonText:~SET_AS_SKIN_POSE_BUTTONTEXT~
category:~SETSKINPOSE_CATEGORY~
internalCategory:"Characters"
Tooltip:~SETSKINPOSE_TOOLTIP~ 
(

	On execute do
	(
		local res = queryBox ~QUERYBOX_SET_THE_SKIN_POSE_CAPTION~ title:~QUERY_CHARACTER_TITLE~
		if res then
		(
			undo ~UNDO_SET_AS_SKIN_POSE~ on
			(
				for obj in selection do
				(
					obj.setSkinPose()
					if (classof obj == CharacterAssembly) do for c in obj.children do
					(
						obj.setSkinPose()
					)
				)	
			)
			redrawViews()
		)
	)

)

macroScript AssumeSkinPose
ButtonText:~BUTTONTEXT_ASSUME_SKIN_POSE~
category:~ASSUMESKINPOSE_CHARACTERS_CATEGORY~
internalCategory:"Characters"
Tooltip:~ASSUMESKINPOSE_TOOLTIP~ 
(
	On execute do
	(	
		undo ~UNDO_ASSUMESKINPOSE~ on
		(
			for s in selection do
			(
				s.assumeSkinPose()
				if (classof s == CharacterAssembly) do for c in s.children do
				(
					c.assumeSkinPose()
				)
			)				
		)
		redrawViews()			
	)	
)

macroScript SkinPoseMode
ButtonText:~SKIN_POSE_MODE_BUTTONTEXT~
category:~SKINPOSEMODE_CATEGORY~
internalCategory:"Characters"
Tooltip:~SKINPOSEMODE_ON_OFF_TOGGLE_TOOLTIP~ 
(
	local determinate = false
	local checked = false
	fn checkstate =
	(
		checked = false
		determinate = false
		local first = false;
		local obj_array = selection as array
		for s in selection do 
		(
			if (classof s == CharacterAssembly) then
			(
				join obj_array s.children
			)
		)
		for i in obj_array do
		(
			if first then 
			(
				local x = i.SkinPoseMode
				if checked then
				(
					if (not x) then determinate = false
				)
				else
				(
					if x then determinate = false
				)
			) 
			else
			(
				first = true
				checked = i.skinPoseMode
				determinate = true
			)
		)
		checked
	)

	On isChecked Return checkState()

	On isEnabled Return determinate

	On Execute Do (
		local obj_array = selection as array
		for s in selection do if (classof s == CharacterAssembly) then
			join obj_array s.children

		if selection.count == 1 and (classof $ == CharacterAssembly) and (GetCommandPanelTaskMode() == #modify) and 
		   (g_characterTimer != undefined) then
			g_characterTimer.active = true
			
		For i In obj_array Do
			i.skinPoseMode = not checked

		redrawViews()			
	)
)

